% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cla_glmnet.R
\name{cla_glmnet}
\alias{cla_glmnet}
\title{LASSO logistic regression (glmnet)}
\usage{
cla_glmnet(attribute, lambda = c("lambda.min", "lambda.1se"))
}
\arguments{
\item{attribute}{target attribute name (binary)}

\item{lambda}{which lambda to use ("lambda.min" or "lambda.1se")}
}
\value{
returns a \code{cla_glmnet} object
}
\description{
Logistic regression with L1 penalty using \code{glmnet::cv.glmnet}.
}
\examples{
if (requireNamespace("glmnet", quietly = TRUE)) {
 data(iris)
 iris_bin <- iris
 iris_bin$IsVersicolor <- ifelse(iris_bin$Species == "versicolor", 1, 0)
 model <- cla_glmnet("IsVersicolor")
 model <- fit(model, iris_bin)
 pred <- predict(model, iris_bin)
 table(pred, iris_bin$IsVersicolor)
}
}
