% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{mean_estimate}
\alias{mean_estimate}
\alias{median_estimate}
\title{Aggregators for scalar estimates}
\usage{
mean_estimate(xs)

median_estimate(xs)
}
\arguments{
\item{xs}{A list of numeric values or numeric vectors. Elements are
unlisted and concatenated prior to aggregation, so \code{xs} may
contain scalars or length-\eqn{k} vectors.}
}
\value{
A single numeric value (the mean or median of all entries in
\code{xs}.
}
\description{
These helpers implement simple aggregation schemes for panel-level
and repetition-level estimates in \code{\link{crossfit}} and
\code{\link{crossfit_multi}}.
}
\details{
In \code{mode = "estimate"}, each repetition typically produces a list
of numeric values (one per evaluation panel). The functions
\code{mean_estimate()} and \code{median_estimate()} aggregate such
lists into a single numeric value.
}
\examples{
xs <- list(c(1, 2, 3), 4, c(5, 6))
mean_estimate(xs)
xs <- list(c(1, 100), 10, 20)
median_estimate(xs)
}
