% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{styles_growth_sensitivity}
\alias{styles_growth_sensitivity}
\title{Rental-growth (indexation) sensitivity of leveraged equity IRR by style}
\usage{
styles_growth_sensitivity(
  styles,
  delta = c(-0.01, 0, 0.01),
  config_dir = system.file("extdata", package = "cre.dcf")
)
}
\arguments{
\item{styles}{Character vector of style identifiers.}

\item{delta}{Numeric vector of rental-growth shocks (additive) applied to
the \code{index_rate} parameter of the preset.}

\item{config_dir}{Directory where preset YAML files are stored.}
}
\value{
A tibble with columns:
\itemize{
\item \code{style} (character),
\item \code{shock_growth} (numeric, growth shock added to \code{index_rate}),
\item \code{irr_equity} (numeric, leveraged equity IRR under the shock).
}
}
\description{
This helper perturbs the global \code{index_rate} parameter of each style preset
by a given grid of additive shocks and recomputes the leveraged equity IRR.
}
\details{
It therefore measures how dependent each style is on rental_growth
(via indexation and lease renewals) to reach its target equity_IRR.
In canonical calibrations, core strategies tend to be less sensitive than
value_added or opportunistic profiles, which rely more heavily on
growth and lease-up.
}
