% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matcalc.R
\name{transform_upper}
\alias{transform_upper}
\title{Transform to upper triangular}
\usage{
transform_upper(M)
}
\arguments{
\item{M}{An \eqn{n\times n} or \eqn{n\times (n+1)} matrix.}
}
\value{
The transformed \eqn{n\times n} or 
        \eqn{n\times (n+1)} matrix.
}
\description{
Transform an \eqn{n\times n} matrix to upper-triangular
form, using a series of row operations.
}
\details{
The algorithm used for the transformation is Gauss 
elimination, which makes use of row operations. If the input
matrix has \eqn{n+1} columns, the transformed 
\eqn{n\times (n+1)} matrix can be used to find the solution
of the associated system of linear equations.
}
\examples{
# 3X3 matrix
#
# [ 3  1  1
#   1 -1  2
#  -1  1  1]

# Input matrix
A <- matrix(c(3,1,2,1,1,-1,1,1,-1),ncol=3)

# Upper-triangular matrix
U <- transform_upper(A)
print(U)

}
