% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolation.R
\name{linpol}
\alias{linpol}
\title{1D linear interpolation}
\usage{
linpol(x, f, x0)
}
\arguments{
\item{x}{A vector of real numbers. Grid points corresponding to the tabulated
(known) values of the function.}

\item{f}{A vector of real numbers. Tabulated (known) values of the function, 
corresponding to the grid \code{x}.}

\item{x0}{A vector of real numbers. These are the grid points chosen for
the interpolation. All points of this grid need to be within the tabulated grid.}
}
\value{
A vector of real numbers. These are the actual interpolated values
(calculated using linear interpolation), corresponding to all values of 
the grid \code{x0}.
}
\description{
Classic linear interpolation between two tabulated (known) points of a
one-variable function.
}
\examples{
# Tabulated values: f(x) = 2*x^2-1
x <- c(0,1,3,7)
f <- 2*x^2-1

# Grid for interpolation
x0 <- seq(0,7,length=501)

# Interpolated points
f <- linpol(x,f,x0)
print(f)

}
