% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matcalc.R
\name{gauss_elim}
\alias{gauss_elim}
\title{Gaussian Elimination}
\usage{
gauss_elim(M)
}
\arguments{
\item{M}{The \eqn{n\times (n+1)} augmented matrix of
coefficients corresponding to the system of \eqn{n}
linear equations in \eqn{n} unknowns, \eqn{Ax=b}.}
}
\value{
A vector of length \eqn{n} containing the \eqn{n}
        numeric solutions for the \eqn{n} unknowns. If the
        system has no solutions or an infinite number of
        solutions, the function returns NULL and dumps a
        warning message.
}
\description{
Solution of a system of \eqn{n} equations in \eqn{n} unknowns,
using Gaussian elimination.
}
\details{
The linear system to solve is \eqn{Ax=b}, where \eqn{A} is
the \eqn{n\times n} matrix of coefficients of the \eqn{n}
unknowns in the \eqn{n\times 1} vector \eqn{x}, and \eqn{b}
is the \eqn{n\times 1} vector of known numbers. Gaussian
elimination consists of a series of so-called row operations
that transform \eqn{A} in an upper-triangular matrix. The
system corresponding to the transformed matrix can be solved
very quickly.
}
\examples{
# System of three equations in three unknowns
#
# 3x_1 + x_2 +  x_3 = 6
#  x_1 - x_2 + 2x_3 = 4
# -x_1 + x_2 +  x_3 = 2

# Augmented matrix M=(A|b)
M <- matrix(c(3,1,-1,1,-1,1,1,2,1,6,4,2),ncol=4)

# Solution via Gauss elimination
x <- gauss_elim(M)
print(x)

}
