% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matcalc.R
\name{LUdeco}
\alias{LUdeco}
\title{LU decomposition}
\usage{
LUdeco(A, method = "crout")
}
\arguments{
\item{A}{An \eqn{n\times n} matrix.}

\item{method}{A character string. This calls two different
procedures for the decomposition. Only "crout" 
(default) and "doolittle" are recognised methods. A
different character string forces the function to
return NULL.}
}
\value{
A named list with the lower triangular, L,
        upper triangular, U, matrices, and with a vector,
        ord, containing the permutation needed to achieve
        the LU factorisation.
}
\description{
Transform an \eqn{n\times n} matrix into a product of a 
lower-triangular and upper-triangular matrices, using the
Crout (method="crout" - default) or Doolittle (method=
"doolittle") method.
}
\details{
The "crout" method returns the upper triangular matrix, U, 
with ones on its diagonal. The "doolittle" method returns
the lower triangular matrix, L, with ones on its diagonal.

Some matrices do not have an LU decomposition unless a row
permutation is done to the matrix. In this function, the 
order of such a permutation is included in the named vector
\code{ord}, returned as part of the output. When the vector
is equal to 1,2,...,n (first n numbers, naturally ordained),
this means that there was no need of permuting the original
matrix to carry out the LU decomposition.
}
\examples{
# 3X3 matrix
#
# [ 3  1  1
#   1 -1  2
#  -1  1  1]

# Input matrix
A <- matrix(c(3,1,-1,1,-1,1,1,2,1),ncol=3)

# LU decomposition
ltmp <- LUdeco(A)
print(ltmp$L)
print(ltmp$U)
print(ltmp$ord) # No permutation needed

# The product is the original matrix, A
print(ltmp$L\%*\%ltmp$U)

# Singular matrix with LU decomposition
A <- matrix(c(1,0,0,0,1,1,1,0,0),ncol=3)
print(det(A))
ltmp <- LUdeco(A,"doolittle")
print(ltmp$L)
print(ltmp$U)
print(ltmp$ord) # No permutation needed

# The product is the original matrix, A
print(ltmp$L\%*\%ltmp$U)

# Singular matrix without LU decomposition
A <- matrix(c(1,0,0,0,0,0,0,0,0),ncol=3)
ltmp <- LUdeco(A)
print(ltmp)
#
}
