% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_h3_grid.R
\name{build_h3_grid}
\alias{build_h3_grid}
\title{Build an H3 grid as an sf object}
\usage{
build_h3_grid(h3_resolution, id_hex = NULL, code_muni = NULL, boundary = NULL)
}
\arguments{
\item{h3_resolution}{Integer. H3 resolution.}

\item{id_hex}{Character/integer vector of H3 cell ids (optional).}

\item{code_muni}{Integer. Seven-digit IBGE municipality code (optional).}

\item{boundary}{An sf polygon for the area of interest (optional).}
}
\value{
An sf object (CRS 4326) with columns \code{id_hex} and \code{geometry}.
}
\description{
Internal helper to build an H3 grid either:
\itemize{
\item from a vector of H3 cell ids (\code{id_hex}), or
\item from the municipality boundary (\code{code_muni}) using geobr (year fixed at 2024).
}
}
\keyword{internal}
