% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncinfo.R
\name{ncinfo}
\alias{ncinfo}
\title{Get information about the content of a NetCDF file.}
\usage{
ncinfo(infile, info = "s", verbose = FALSE, nc = NULL)
}
\arguments{
\item{infile}{Filename of input NetCDF file. This may include the directory
(character).}

\item{info}{The output can be: long ('l'), medium ('m') and short ('s')
(character). Default is short ('s'). The option 'l' additionally returns a
list object with file information.}

\item{verbose}{logical; if TRUE, progress messages are shown}

\item{nc}{Alternatively to \code{infile} you can specify the input as an
object of class \code{ncdf4} (as returned from \code{ncdf4::nc_open}).}
}
\value{
prints the content of the infile NetCDF.
}
\description{
Shows the content of a NetCDF file in three different detail levels.
}
\examples{
## Create an example NetCDF file with a similar structure as used by CM
## SAF. The file is created with the ncdf4 package.  Alternatively
## example data can be freely downloaded here: <https://wui.cmsaf.eu/>

library(ncdf4)

## create some (non-realistic) example data

lon <- seq(5, 15, 0.5)
lat <- seq(45, 55, 0.5)
time <- seq(as.Date("2000-01-01"), as.Date("2010-12-31"), "month")
origin <- as.Date("1983-01-01 00:00:00")
time <- as.numeric(difftime(time, origin, units = "hour"))
data <- array(250:350, dim = c(21, 21, 132))

## create example NetCDF

x <- ncdim_def(name = "lon", units = "degrees_east", vals = lon)
y <- ncdim_def(name = "lat", units = "degrees_north", vals = lat)
t <- ncdim_def(name = "time", units = "hours since 1983-01-01 00:00:00",
 vals = time, unlim = TRUE)
var1 <- ncvar_def("SIS", "W m-2", list(x, y, t), -1, prec = "short")
vars <- list(var1)
ncnew <- nc_create(file.path(tempdir(),"CMSAF_example_file.nc"), vars)
ncvar_put(ncnew, var1, data)
ncatt_put(ncnew, "lon", "standard_name", "longitude", prec = "text")
ncatt_put(ncnew, "lat", "standard_name", "latitude", prec = "text")
nc_close(ncnew)

## Get information on a medium detail level of the example CM SAF NetCDF
## file:
ncinfo(infile = file.path(tempdir(),"CMSAF_example_file.nc"), info = "m")

unlink(file.path(tempdir(),"CMSAF_example_file.nc"))
}
