% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_cdfs.R
\name{aep_cdf}
\alias{aep_cdf}
\title{Asymmetric Exponential Power (AEP) link CDF}
\usage{
aep_cdf(x, theta1, theta2)
}
\arguments{
\item{x}{Numeric vector}

\item{theta1}{Left tail parameter (theta1 > 0)}

\item{theta2}{Right tail parameter (theta2 > 0)}
}
\value{
CDF values
}
\description{
The AEP distribution with alpha = 0.5 (fixed for identifiability).
}
\details{
For x <= 0:
F(x) = 0.5 * (1 - P(1/theta1, u1))
where u1 = (|x| * 2 * Gamma(1 + 1/theta1))^theta1

For x > 0:
F(x) = 0.5 + 0.5 * P(1/theta2, u2)
where u2 = (x * 2 * Gamma(1 + 1/theta2))^theta2

P(a, x) is the regularized incomplete gamma function (pgamma).

Special case: theta1 = theta2 gives a symmetric distribution.
Note: theta = 2 has a Gaussian kernel but is NOT equal to probit due to scaling.

Reference: Naranjo et al. (2015) Statistics and Computing
}
\keyword{internal}
