\name{alvarado_appendicitis}
\alias{alvarado_appendicitis}
\title{
Alvarado Score for Acute Appendicitis
}
\description{
Calculates the Alvarado Score (also known as the MANTRELS score) to stratify the risk of acute appendicitis in patients presenting with abdominal pain. The score uses clinical symptoms, physical exam findings, and laboratory values to categorize patients into Low, Moderate, or High risk groups, helping to guide decisions regarding imaging (CT) and surgical consultation.
}
\usage{
alvarado_appendicitis(migratory_pain, anorexia, nausea_vomiting, rlq_tenderness,
                      rebound_tenderness, elevated_temp, leukocytosis, shift_left)
}
\arguments{
  \item{migratory_pain}{
Numeric (0 or 1). Migration of pain to the right lower quadrant. (1 = Yes, +1 point).
}
  \item{anorexia}{
Numeric (0 or 1). Anorexia or ketones in urine. (1 = Yes, +1 point).
}
  \item{nausea_vomiting}{
Numeric (0 or 1). Nausea or vomiting. (1 = Yes, +1 point).
}
  \item{rlq_tenderness}{
Numeric (0 or 1). Tenderness in the right lower quadrant. (1 = Yes, +2 points).
}
  \item{rebound_tenderness}{
Numeric (0 or 1). Rebound tenderness. (1 = Yes, +1 point).
}
  \item{elevated_temp}{
Numeric (0 or 1). Temperature >= 37.3 C (99.1 F). (1 = Yes, +1 point).
}
  \item{leukocytosis}{
Numeric (0 or 1). Leukocytosis > 10,000 /uL. (1 = Yes, +2 points).
}
  \item{shift_left}{
Numeric (0 or 1). Shift to the left (neutrophils > 75\%). (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{Total_Score}{The sum of the weighted criteria (Range 0-10).}
\item{Risk_Group}{Risk classification (Low 0-3, Moderate 4-6, High 7-10).}
\item{Recommendation}{Clinical guidance based on the risk group.}
}
\references{
Alvarado A. A practical score for the early diagnosis of acute appendicitis. Ann Emerg Med. 1986;15(5):557-564. doi:10.1016/s0196-0644(86)80993-3
}
\examples{

# Example 1: High Risk (Surgical Candidate)
# Migratory pain, Nausea, RLQ Tenderness (2), Rebound, Fever, Leukocytosis (2)
# Score = 1 + 1 + 2 + 1 + 1 + 2 = 8
alvarado_appendicitis(1, 0, 1, 1, 1, 1, 1, 0)

# Example 2: Low Risk
# Nausea only
# Score = 1
alvarado_appendicitis(0, 0, 1, 0, 0, 0, 0, 0)
}
