% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_detailed_report.R
\name{generate_detailed_report}
\alias{generate_detailed_report}
\title{Generate a Detailed Report of Dataset Comparison}
\usage{
generate_detailed_report(
  comparison_results,
  output_format = "text",
  file_name = NULL
)
}
\arguments{
\item{comparison_results}{A list containing the results of dataset comparisons.}

\item{output_format}{Format of the output ('text' or 'html').}

\item{file_name}{Name of the file to save the report to (applicable for 'html' format).}
}
\value{
The detailed report. For 'text', prints to console. For 'html', writes to file.
}
\description{
Creates a detailed report outlining all the differences found in the comparison,
including variable differences, observation differences, and group-based discrepancies.
}
\examples{
\dontrun{
  generate_detailed_report(comparison_results, output_format = "text")
}
}
