% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aemet-beaches.R
\name{aemet_beaches}
\alias{aemet_beaches}
\title{AEMET beaches}
\usage{
aemet_beaches(verbose = FALSE, return_sf = FALSE)
}
\arguments{
\item{verbose}{Logical \code{TRUE/FALSE}. Provides information about the flow of
information between the client and server.}

\item{return_sf}{Logical \code{TRUE} or \code{FALSE}.
Should the function return an \code{\link[sf:sf]{sf}} spatial object? If \code{FALSE}
(the default value) it returns a \code{\link[tibble:tibble]{tibble}}. Note that
you need to have the \CRANpkg{sf} package installed.}
}
\value{
A \code{\link[tibble:tibble]{tibble}} or a \CRANpkg{sf} object.
}
\description{
Get AEMET beaches.
}
\details{
The first result of the API call on each session is (temporarily) cached in
the assigned \code{\link[=tempdir]{tempdir()}} for avoiding unneeded API calls.
}
\section{API Key}{
You need to set your API Key globally using \code{\link[=aemet_api_key]{aemet_api_key()}}.
}

\examples{
\dontshow{if (aemet_detect_api_key()) withAutoprint(\{ # examplesIf}
library(tibble)
beaches <- aemet_beaches()
beaches

# Cached during this R session
beaches2 <- aemet_beaches(verbose = TRUE)

identical(beaches, beaches2)

# Select an map beaches
library(dplyr)
library(ggplot2)
library(mapSpain)

# Alicante / Alacant
beaches_sf <- aemet_beaches(return_sf = TRUE) |>
  filter(ID_PROVINCIA == "03")

prov <- mapSpain::esp_get_prov("Alicante")

ggplot(prov) +
  geom_sf() +
  geom_sf(
    data = beaches_sf, shape = 4, size = 2.5,
    color = "blue"
  )
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=aemet_forecast_beaches]{aemet_forecast_beaches()}}

Other aemet_api_data: 
\code{\link{aemet_alert_zones}()},
\code{\link{aemet_alerts}()},
\code{\link{aemet_daily_clim}()},
\code{\link{aemet_extremes_clim}()},
\code{\link{aemet_forecast_beaches}()},
\code{\link{aemet_forecast_daily}()},
\code{\link{aemet_forecast_fires}()},
\code{\link{aemet_last_obs}()},
\code{\link{aemet_monthly}},
\code{\link{aemet_normal}},
\code{\link{aemet_stations}()}
}
\concept{aemet_api_data}
