% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/georeference.R
\name{plot_tiles}
\alias{plot_tiles}
\alias{tiles_to_polygon}
\title{Plot slippy map tiles}
\usage{
plot_tiles(
  x,
  ...,
  add = FALSE,
  label = TRUE,
  cex = 0.6,
  add_coast = TRUE,
  include_zoom = TRUE
)

tiles_to_polygon(x)
}
\arguments{
\item{x}{tiles as create by \code{ceramic_tiles()}}

\item{...}{arguments passed to \code{graphics::rect()}}

\item{add}{add to an existing plot?}

\item{label}{include text label?}

\item{cex}{relative size of text label if drawn (see \code{text()})}

\item{add_coast}{include a basic coastline on the plot?}

\item{include_zoom}{include zoom level with text label if drawn?}
}
\value{
\code{\link[=plot_tiles]{plot_tiles()}} is called for its side-effect, a plot, and returns \code{NULL} invisibly.
\link{tiles_to_polygon} returns a wk rct vector
}
\description{
Create a new plot of tile rectangles, or add to an existing plot.
}
\details{
The extent ('xmin', 'xmax', 'ymin', 'ymax') is used directly to draw the tiles so must be in the
native Mercator coordinate system used by most tile servers.
}
\examples{
if (!is.null(get_api_key())) {
  get_tiles_zoom(zoom = 1)
  tiles <- ceramic_tiles(zoom = 1)
  plot_tiles(tiles)
}
}
