
<!-- README.md is generated from README.Rmd. Please edit that file -->

# btw <a href="https://posit-dev.github.io/btw/"><img src="man/figures/logo.png" align="right" height="138" alt="btw website" /></a>

> A complete toolkit for connecting R and LLMs

<!-- badges: start -->

[![CRAN
status](https://www.r-pkg.org/badges/version/btw)](https://CRAN.R-project.org/package=btw)
[![R-universe
version](https://posit-dev.r-universe.dev/btw/badges/version)](https://posit-dev.r-universe.dev/btw)
[![R-CMD-check](https://github.com/posit-dev/btw/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/posit-dev/btw/actions/workflows/R-CMD-check.yaml)
[![Codecov test
coverage](https://codecov.io/gh/posit-dev/btw/graph/badge.svg)](https://app.codecov.io/gh/posit-dev/btw)
<!-- badges: end -->

## Overview

btw helps R users work with Large Language Models, whether you’re
pasting context into ChatGPT, chatting with an AI assistant in your IDE,
or building LLM-powered applications.

The challenge: LLMs need context about your R environment to be
helpful—your data structures, the packages you’re using, relevant
documentation.

btw provides a flexible toolkit that works across different workflows:

- **Copy-paste to external LLMs:** Quickly gather context from your R
  session and copy it to your clipboard for pasting into ChatGPT,
  Claude, or any other chat interface.
- **Interactive chat in R:** Launch a full-featured AI assistant
  directly in your IDE that can explore your environment, read
  documentation, and help you write code.
- **Build LLM-powered tools:** Integrate btw’s capabilities into your
  own applications, whether you’re creating custom chat interfaces or
  connecting R to coding agents.

## Quick Start

### Copy-paste workflow

Use `btw()` to gather context from your R session and copy it to your
clipboard:

``` r
library(btw)

# Describe a data frame
btw(mtcars)

# Include package or function documentation
btw("{dplyr}", ?dplyr::across)

# Combine multiple pieces of context
btw(mtcars, "{dplyr}", "How do I calculate the mean mpg by cylinder?")
```

The context is copied to your clipboard, ready to paste into ChatGPT,
Claude, or any LLM chat interface.

### Interactive chat in your IDE

Launch a chat interface with `btw_app()`:

``` r
btw_app()
```

<img src="man/figures/btw-app.png" alt="Screenshot of btw_app() in action. In the sidebar, there is a list of tools that can be toggled on and off, and in the main panel a chat interface. In the chat we can see several tool calls have been made to read files in the current project.">

For persistent project context, create a `btw.md` file with
`use_btw_md()`. This creates a project-specific configuration file where
you can define your preferred LLM provider, model, and custom
instructions that apply to all conversations in your project.

### Building with btw

btw supercharges [ellmer](https://ellmer.tidyverse.org/)! Use
`btw_client()` for a pre-configured chat client, the same client used by
`btw_app()`.

``` r
# Uses provider, model, tools and instructions from btw.md
chat <- btw_client()
chat$chat("Help me write documentation for...")
```

Or use `btw_tools()` to get a list of tools you can register with any
ellmer chat client.

``` r
library(ellmer)

chat <- chat_anthropic()  # or chat_openai(), chat_ollama(), etc.
chat$register_tools(btw_tools())

chat$chat("What data frames are in my environment?")
```

Pick and choose which tools you use with friendly group names

``` r
# Only provide documentation and file tools
chat$register_tools(btw_tools(c("docs", "files")))
```

or expose btw tools to external coding agents via the [Model Context
Protocol](https://modelcontextprotocol.org/) using
[mcptools](https://posit-dev.github.io/mcptools/).

``` r
# Run as a background process or in a separate R session
btw_mcp_server()
```

You can [configure the MCP
server](https://posit-dev.github.io/btw/reference/mcp.html) in Claude
Desktop, Continue, or other MCP-compatible tools to give them access to
your R environment.

## Installation

You can install btw from CRAN:

``` r
install.packages("btw")
```

To install the latest development version, you can install from
[posit-dev.r-universe.dev](https://posit-dev.r-universe.dev/):

``` r
# install.packages("pak")

pak::repo_add("https://posit-dev.r-universe.dev")
pak::pak("btw")
```

Or you can install the development version from
[GitHub](https://github.com/posit-dev/btw):

``` r
# install.packages("pak")
pak::pak("posit-dev/btw")
```

## Learn More

- 🌐 [Package website](https://posit-dev.github.io/btw/)
- 📚 [Function reference](https://posit-dev.github.io/btw/reference/)
- 💻 [GitHub repository](https://github.com/posit-dev/btw)

For questions or issues, please [open an issue on
GitHub](https://github.com/posit-dev/btw/issues).
