% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc_ifelse.R
\name{bc_ifelse}
\alias{bc_ifelse}
\alias{bc_ifelse,ANY-method}
\title{Broadcasted Ifelse}
\usage{
bc_ifelse(test, yes, no, ...)

\S4method{bc_ifelse}{ANY}(test, yes, no)
}
\arguments{
\item{test}{a vector or array,
with the type \code{logical}, \code{integer}, or \code{raw},
and a length equal to \code{prod(bc_dim(yes, no))}. \cr
If \code{yes} / \code{no} are of type \code{raw}, \code{test} is not allowed to contain any \code{NA}s.}

\item{yes, no}{conformable vectors/arrays of the same type. \cr
All \link[base]{atomic} types are supported. \cr
Recursive arrays of type \link[base]{list} are also supported.}

\item{...}{further arguments passed to or from methods. \cr \cr}
}
\value{
The output, here referred to as \code{out},
will be an array of the same type as \code{yes} and \code{no}. \cr
If \code{test} has the same dimensions as \code{bc_dim(yes, no)},
then \code{out} will also have the same dimnames as \code{test}. \cr
If \code{test} is a \link{broadcaster}, then \code{out} will also be a \link{broadcaster}. \cr
\cr
After broadcasting \code{yes} against \code{no},
given any element index \code{i},
the following will hold for the output:
\itemize{
\item when \code{test[i] == TRUE}, \code{out[i]} is \code{yes[i]};
\item when \code{test[i] == FALSE}, \code{out[i]} is \code{no[i]};
\item when \code{test[i]} is \code{NA},
\code{out[i]} is \code{NA} when \code{yes} and \code{no} are atomic,
and \code{out[i]} is \code{list(NULL)} when \code{yes} and \code{no} are recursive. \cr \cr
}
}
\description{
The \code{bc_ifelse()} method
performs a broadcasted form of \link[base]{ifelse}. \cr
}
\examples{

x.dim <- c(5, 3, 2)
x.len <- prod(x.dim)

x <- array(sample(1:100), x.dim)
y <- array(sample(1:100), c(5, 1, 1))

cond <- bc.i(x, y, ">")

bc_ifelse(cond, yes = x^2, no = -y)
}
