% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_inflation_rate.R
\name{plot_inflation_rate}
\alias{plot_inflation_rate}
\title{Plot Brazilian Inflation Rate (IPCA)}
\usage{
plot_inflation_rate(data, language = "eng")
}
\arguments{
\item{data}{Tibble returned by \code{get_inflation_rate()}, with columns \code{date} and \code{value}.
The \code{value} column represents the monthly IPCA inflation rate (\%).}

\item{language}{Language for titles and labels: "pt" (Portuguese) or "eng" (English).}
}
\value{
A \code{ggplot2} object showing the monthly inflation rate over time.
}
\description{
Generates a time series plot of Brazil's monthly inflation rate measured
by the IPCA (Índice Nacional de Preços ao Consumidor Amplo).
The IPCA is Brazil's official inflation index and is widely used for
monetary policy decisions, contract indexation, and economic analysis.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# Example 1: English version
inflation_data <- get_inflation_rate(2020, 2024)
inflation_plot <- plot_inflation_rate(inflation_data)
print(inflation_plot)

# Example 2: Portuguese version
dados_inflacao <- get_inflation_rate(2020, 2024, language = "pt")
grafico_inflacao <- plot_inflation_rate(dados_inflacao, language = "pt")
print(grafico_inflacao)
\dontshow{\}) # examplesIf}
}
