% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breathtestcore.R
\docType{data}
\name{usz_13c_a}
\alias{usz_13c_a}
\title{Exotic 13C breath test data}
\usage{
data(usz_13c_a)
}
\description{
13C time series PDR data from three different groups in a randomized
(= not-crossover) design. This are unpublished data from
\href{https://www.usz.ch/fachbereich/gastroenterologie-und-hepatologie/}{Gastroenterology and Hepatology,
University Hospital Zurich}. 

Data are formatted as described in \code{\link{usz_13c}}. These time series present
a challenge for algorithms.
}
\examples{
\donttest{
library(dplyr)
library(ggplot2)
data(usz_13c_a)
d = usz_13c_a \%>\% 
  cleanup_data() \%>\% # recommended to test for validity
  nlme_fit()
plot(d)
}
}
\keyword{datasets}
