% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brand_color.R
\name{brand_color_pluck}
\alias{brand_color_pluck}
\title{Extract a color value from a brand object}
\usage{
brand_color_pluck(brand, key)
}
\arguments{
\item{brand}{A brand object created by \code{\link[=read_brand_yml]{read_brand_yml()}} or
\code{\link[=as_brand_yml]{as_brand_yml()}}.}

\item{key}{A character string representing the color key to extract.}
}
\value{
The resolved color value (typically a hex color code) if the key
exists, otherwise returns the key itself.
}
\description{
Safely extracts a color value from a \code{brand} object based on the provided
key. This function handles color references and resolves them, including
references to palette colors and other theme colors. It detects and prevents
cyclic references.
}
\details{
The function checks for the color key in both the main color theme and the
color palette. It can resolve references between colors (e.g., if "primary"
references "palette.blue"). If a cyclic reference is detected (e.g., A
references B which references A), the function will throw an error.
}
\examples{
brand <- as_brand_yml(list(
  color = list(
    primary = "blue",
    secondary = "info",
    info = "light-blue",
    palette = list(
      blue = "#004488",
      light_blue = "#c3ddff"
    )
  )
))

# Extract the primary color
brand_color_pluck(brand, "primary") # "#004488"

# Extract a color that references another color
brand_color_pluck(brand, "info") # "#c3ddff"

# Extract a color that references another color
# which in turn references the palette
brand_color_pluck(brand, "secondary") # "#c3ddff"

# Extract a color that isn't defined
brand_color_pluck(brand, "green") # "green"

# Use brand_pluck() if you need direct (resolved) values
brand_pluck(brand, "color", "primary") # "#004488"
brand_pluck(brand, "color", "info") # "#c3ddff"
brand_pluck(brand, "color", "green") # NULL

}
\seealso{
Other brand.yml helpers: 
\code{\link{brand_has}()},
\code{\link{brand_pluck}()},
\code{\link{with_brand_yml_path}()}
}
\concept{brand.yml helpers}
