% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_list_stats.R
\name{median.sim_list}
\alias{median.sim_list}
\title{Compute the "median" of a collection of spatial interaction models}
\usage{
\method{median}{sim_list}(
  x,
  na.rm = FALSE,
  flows = c("full", "destination", "attractiveness"),
  method = c("euclidean"),
  return_distances = FALSE,
  ...
)
}
\arguments{
\item{x}{a collection of spatial interaction models, an object of class
\code{sim_list}}

\item{na.rm}{not used}

\item{flows}{\code{"full"} (default),  \code{"destination"} or \code{"attractiveness"}, see
details.}

\item{method}{the distance measure to be used. Currently only \code{"euclidean"}
is supported}

\item{return_distances}{should the distances computed to find the median be
returned as a \code{distances} attribute of the resulting object? (defaults to
\code{FALSE})}

\item{...}{additional parameters (not used currently)}
}
\value{
a spatial interaction model, an object of class \code{sim} with
additional attributes
}
\description{
This function computes all pairwise distances between spatial interaction
models (SIMs) of its \code{x} parameter, using \code{sim_distance()} with the specified
distance parameters. Then it returns the "median" of the collection defined
as the SIM that is in average the closest to all the other SIMs. Tie breaking
uses the order of the SIMs in the collection.
}
\details{
As distance calculation can be slow in a large collection of SIMs, the
distance object can be returned as a \code{distances} attribute of the median SIM
by setting the \code{return_distances} parameter to \code{TRUE}. In addition, the
returned SIM has always two attributes:
\itemize{
\item \code{index} gives the index of the mode in the original \code{sim_list}
\item \code{distortion} gives the mean of the distances from the median SIM to all
the other SIMs
}
}
\examples{
distances <- french_cities_distances[1:10, 1:10] / 1000 ## convert to km
production <- rep(1, 10)
attractiveness <- log(french_cities$area[1:10])
all_flows <- grid_blvim(distances, production, seq(1.05, 1.45, by = 0.1),
  seq(1, 3, by = 0.5) / 400,
  attractiveness,
  bipartite = FALSE,
  epsilon = 0.1, iter_max = 1000,
)
all_flows_median <- median(all_flows)
attr(all_flows_median, "index")
attr(all_flows_median, "distortion")
median(all_flows, flows = "destination")
median(all_flows, flows = "attractiveness")
}
