% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sniff_groups_stm_run.R
\name{sniff_groups_stm_run}
\alias{sniff_groups_stm_run}
\title{Run Structural Topic Modeling Analysis}
\usage{
sniff_groups_stm_run(groups_stm_prepare, k_topics = 12, n_top_documents = 50)
}
\arguments{
\item{groups_stm_prepare}{A prepared STM object from \code{sniff_groups_stm_prepare()}}

\item{k_topics}{Number of topics to model (default: 12)}

\item{n_top_documents}{Number of top documents to each topic (default: 50)}
}
\value{
A list containing:
\itemize{
\item{topic_proportion2: Data frame with topic proportions and top terms}
\item{tab_top_documents: Data frame of top documents for each topic}
}
}
\description{
Performs structural topic modeling on prepared text data and returns topic proportions
and top documents for each topic.
}
\details{
This function:
\itemize{
\item{Fits an STM model with specified number of topics}
\item{Identifies top terms for each topic}
\item{Calculates topic proportions}
\item{Identifies top documents for each topic}
}
}
\examples{
\dontrun{
# Prepare data first
stm_data <- sniff_groups_stm_prepare(network_data)

# Run topic modeling
stm_results <- sniff_groups_stm_run(stm_data, k_topics = 15)

# Access results
stm_results$topic_proportion2  # Topic proportions and terms
stm_results$tab_top_documents  # Top documents per topic
}

}
