% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guess_coupled.R
\name{show_guess_coupled}
\alias{show_guess_coupled}
\title{Plot of the initial guess for the Baranyi-Ratkowsky model}
\usage{
show_guess_coupled(
  fit_data,
  guess,
  mode = "two_steps",
  logbase_mu = exp(1),
  logbase_logN = 10
)
}
\arguments{
\item{fit_data}{Tibble (or data.frame) of data for the fit. The shape of the data will depend on the
fitting \code{mode} (see \code{\link[=fit_coupled_growth]{fit_coupled_growth()}})}

\item{guess}{Named vector with the initial guess of the model parameters}

\item{mode}{the type of model fitting approach. Either \code{two_steps} (fitted from the
values of \code{mu} and \code{lambda}) or \code{one_step} (fitted from logN)}

\item{logbase_mu}{Base for the definition of mu. By default, \code{exp(1)} (natural logarithm).}

\item{logbase_logN}{Base for the definition of logN. By default, 10 (decimal logarithm).}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} comparing the model prediction against the data
}
\description{
Compares the prediction corresponding to a guess of the parameters of the Baranyi-Ratkowsky
model against experimental data
}
