% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_classes.R
\name{new_bias_mitigations}
\alias{new_bias_mitigations}
\title{Create bias mitigations tibble}
\usage{
new_bias_mitigations(mitigations_df)
}
\arguments{
\item{mitigations_df}{Data.frame with required columns: bias_type,
mitigation_strategy, confidence_level}
}
\value{
A bid_bias_mitigations S3 object (inherits from data.frame)
}
\description{
Creates a structured bias mitigations tibble for use in bidux functions.
Replaces nested list structures with a validated data.frame structure.
}
\examples{
\dontrun{
mitigations <- new_bias_mitigations(data.frame(
  bias_type = c("confirmation_bias", "selection_bias"),
  mitigation_strategy = c("seek_disconfirming_evidence", "randomize_sample"),
  confidence_level = c(0.8, 0.7)
))
}

}
