% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confounds.R
\name{confound_set}
\alias{confound_set}
\title{Convenience confound sets for fMRIPrep}
\usage{
confound_set(name, n = NULL)
}
\arguments{
\item{name}{Character. The name of the convenience set (see list above).}

\item{n}{Optional integer used by CompCor sets to limit the number of
components (e.g., first 5 or 6). Ignored for other sets.}
}
\value{
A character vector of confound variable names and/or wildcard tokens
that can be passed to \code{read_confounds(..., cvars = confound_set(...))}.
}
\description{
Provides predefined, version-robust groups of confound variable names as
described in the fMRIPrep documentation. These sets abstract over naming
changes between fMRIPrep releases via the internal alias resolver used by
\code{read_confounds()}.
}
\details{
In addition to exact names, wildcard patterns are supported by the confound
resolver:
\itemize{
\item \verb{prefix*} selects all columns that start with \code{prefix} (e.g., \verb{cosine_*},
\verb{motion_outlier_*}, \verb{a_comp_cor_*}).
\item \verb{prefix*[N]} selects the first \code{N} matches (e.g., \verb{a_comp_cor_*[6]}).
\item Suffix combinations such as \verb{_derivative1}, \verb{_power2}, and
\verb{_derivative1_power2} are resolved across both old and new base names
(e.g., \code{trans_x_derivative1} also finds \code{X_derivative1} if present).
}

Available sets (case-insensitive):
\itemize{
\item \code{"motion6"}: 6 rigid-body motion parameters: \code{trans_x}, \code{trans_y},
\code{trans_z}, \code{rot_x}, \code{rot_y}, \code{rot_z}.
\item \code{"motion12"}: \code{motion6} + first temporal derivatives (adds
\verb{*_derivative1}).
\item \code{"motion24"}: \code{motion12} + quadratic terms of base and derivatives (adds
\verb{*_power2} and \verb{*_derivative1_power2}).
\item \code{"global3"}: global signals: \code{csf}, \code{white_matter}, \code{global_signal}.
\item \code{"9p"}: \code{motion6} + \code{global3} (9 parameters total).
\item \code{"36p"}: \code{motion24} + \code{global3} plus their derivatives and quadratics
(i.e., the canonical 36-parameter set).
\item \code{"acompcor"}: anatomical CompCor components (\verb{a_comp_cor_*}). Use \code{n} to
cap the number of components retained, e.g., \code{n = 6} -> \verb{a_comp_cor_*[6]}.
\item \code{"tcompcor"}: temporal CompCor components (\verb{t_comp_cor_*}). Supports \code{n} as
above.
\item \code{"compcor"}: both anatomical and temporal CompCor (applies \code{n} to each
family if provided).
\item \code{"cosine"}: discrete cosine-basis regressors (matches both \verb{cosine_*} and \verb{cosine*}).
\item \code{"outliers"}: outlier/censoring covariates including
\code{framewise_displacement}, \code{rmsd} (if present), \verb{motion_outlier_*}, and
\verb{non_steady_state_outlier*}.
\item \code{"dvars"}: DVARS family: \code{dvars}, \code{std_dvars}, \code{non_std_dvars},
\code{vx_wisestd_dvars} (resolved to whichever names exist in your dataset).
\item \code{"fd"}: framewise displacement only (\code{framewise_displacement}).
}
}
\examples{
# Common usage: 24-parameter motion set
confound_set("motion24")

# 36-parameter model (Satterthwaite/Friston-style)
confound_set("36p")

# First 6 anatomical CompCor components
confound_set("acompcor", n = 6)

# All cosine regressors and outlier indicators
confound_set("cosine")
confound_set("outliers")
}
