% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.bayesianVARs_irf}
\alias{plot.bayesianVARs_irf}
\title{Impulse Responses Plot}
\usage{
\method{plot}{bayesianVARs_irf}(
  x,
  vars = "all",
  quantiles = c(0.05, 0.25, 0.5, 0.75, 0.95),
  default_hair_color = "#FF000003",
  true_irf = NULL,
  ...
)
}
\arguments{
\item{x}{An object of type \code{bayesianVARs_irf} obtained via
\code{\link{irf}}.}

\item{vars}{character vector containing the names of the variables to be
visualized. The default is \code{"all"} indicating that all variables are
visualized.}

\item{quantiles}{numeric vector indicating which quantiles to plot. If
\code{hairy=TRUE} was specified when calling \code{\link{irf}}, a proportion of \code{max(quantiles)} IRFs will be plotted.
Specify \code{0} to plot a point-estimate only. If \code{hairy=FALSE} was specified (the default),
point-wise quantiles will be plotted. Note that the curve of point-wise medians is not necessarily
in the set of IRFs (see Inoue 2022).}

\item{default_hair_color}{the color of the IRF samples, if \code{hairy=TRUE} was specified.}

\item{true_irf}{If the true IRFs are known (because the data was simulated) they can be plotted alongside
the estimates, such that the quality of the estimates may be judged. \code{true_irf} should be a numeric array
with dimensions variables, shocks and time, in that order.}

\item{...}{Currently ignored!}
}
\description{
Visualization of the impulse responses.
Responses are plotted on a grid, where rows correspond to variables
and columns correspond to shocks.
}
\references{
Inoue, A. and Kilian, L. (2022).
Joint Bayesian inference about impulse responses in VAR models.
\emph{Journal of Econometrics}, \doi{10.1016/j.jeconom.2021.05.010}.
}
\seealso{
\code{\link{irf}}
}
\author{
Stefan Haan \email{sthaan@edu.aau.at}
}
