% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhat.R
\name{rhat}
\alias{rhat}
\title{Compute split Rhat statistic}
\usage{
rhat(chains)
}
\arguments{
\item{chains}{A matrix (iterations x chains) or a data.frame with a 'chain'
column and parameter columns.}
}
\value{
Rhat value (matrix input) or named vector of Rhat values.
}
\description{
Compute split Rhat statistic
}
\details{
Uses the formula for split-Rhat proposed by Gelman et al. (2013).
}
\examples{
# Example with matrix
chains <- matrix(rnorm(3000), nrow = 1000, ncol = 3)
rhat(chains)
#' # Example with data frame
chains_df <- data.frame(
  chain = rep(1:3, each = 1000),
  param1 = rnorm(3000),
  param2 = rnorm(3000)
)
rhat(chains_df)
}
\references{
Gelman et al. (2013). Bayesian Data Analysis, 3rd Edition.
}
