% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting_triangle-getters.R
\name{get_delays_from_dates}
\alias{get_delays_from_dates}
\title{Compute delays between report dates and reference dates}
\usage{
get_delays_from_dates(report_dates, reference_dates, delays_unit)
}
\arguments{
\item{report_dates}{Date vector of report dates.}

\item{reference_dates}{Date vector of reference dates.}

\item{delays_unit}{Character string specifying the temporal granularity of
the delays. Options are \code{"days"}, \code{"weeks"}, \code{"months"}, \code{"years"}.
Default is \code{"days"}.}
}
\value{
Numeric vector of delays.
}
\description{
Computes delays between report dates and reference dates
using the specified time unit. This is the inverse operation of
\code{\link[=get_report_dates]{get_report_dates()}}.
}
\examples{
# Compute delays in days
ref_date <- as.Date("2024-01-01")
report_date <- as.Date("2024-01-08")
get_delays_from_dates(report_date, ref_date, "days") # 7

# Compute delays in weeks
report_date_weeks <- as.Date("2024-01-15")
get_delays_from_dates(report_date_weeks, ref_date, "weeks") # 2
}
\seealso{
Reporting triangle construction and validation
\code{\link{[.reporting_triangle}()},
\code{\link{[<-.reporting_triangle}()},
\code{\link{as.data.frame.reporting_triangle}()},
\code{\link{as.matrix.reporting_triangle}()},
\code{\link{as_ChainLadder_triangle}()},
\code{\link{as_reporting_triangle}()},
\code{\link{as_reporting_triangle.data.frame}()},
\code{\link{as_reporting_triangle.matrix}()},
\code{\link{as_reporting_triangle.triangle}()},
\code{\link{assert_reporting_triangle}()},
\code{\link{get_delays_unit}()},
\code{\link{get_max_delay}()},
\code{\link{get_mean_delay}()},
\code{\link{get_quantile_delay}()},
\code{\link{get_reference_dates}()},
\code{\link{get_report_dates}()},
\code{\link{get_reporting_structure}()},
\code{\link{head.reporting_triangle}()},
\code{\link{is_reporting_triangle}()},
\code{\link{new_reporting_triangle}()},
\code{\link{print.reporting_triangle}()},
\code{\link{reporting_triangle-class}},
\code{\link{summary.reporting_triangle}()},
\code{\link{tail.reporting_triangle}()},
\code{\link{truncate_to_delay}()},
\code{\link{truncate_to_quantile}()},
\code{\link{validate_reporting_triangle}()}
}
\concept{reporting_triangle}
