% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tidy_names_types_factors.R
\name{assign_types_names}
\alias{assign_types_names}
\title{Assign tidy types and names to a data.frame}
\usage{
assign_types_names(data, meta_data)
}
\arguments{
\item{data}{data.frame to be tidied. Dates must already be of type date.}

\item{meta_data}{data.frame specifying old column names, new column names and
datatypes of data. Has the following columns:
\itemize{
\item old_column_name : character with the old column name.
\item new_data_type : character denoting the tidy data type. Supported types are:
\itemize{
\item character (will be coerced using \code{as.character()}).
\item integer (will be coerced using \code{as.integer()}).
\item float (will be coerced using \code{as.double()}).
\item factor (will be coerced using \code{as.factor()}).
Will result in a warning if the new factor variable will have more than 10 levels.
\item date (can only confirm correct datatype assignment or coerce characters with format '\%Y-\%m-\%d').
}
\item new_column_name : tidy column name. Can be left blank to keep the old column name.
\item Optional other columns (do not affect behavior).
}}
}
\value{
clean data.frame
}
\description{
Verbosely assign tidy name and data type for each column of a data.frame and
get rid of superfluous columns. Uses a .csv file for assignments to
encourage a data dictionary based workflow.
CAVE! Requires 'Date' type columns to already be read in as Date.
}
\author{
J. Peter Marquardt
}
