% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pam2bioindex.R
\name{pam2bioindex}
\alias{pam2bioindex}
\title{pam2bioindex: PAM to biodiversity index}
\usage{
pam2bioindex(pam, biodiv_index = "dispersion_field", as_sparse = FALSE)
}
\arguments{
\item{pam}{A Presence-Absence-Matrix of matrix class or sparse matrix.}

\item{biodiv_index}{Possible values are alpha, omega,
wbeta (Whittaker’s multiplicative beta index),
laBeta (Lande’s additive beta index)
dispersion_field, all.}

\item{as_sparse}{Return indices as sparse objects}
}
\value{
An object of class \code{\link[bamm]{bioindex}} with three slots
each represents a matrix of diversity indices: alpha, omega, and
dispersion field, richness_field.
}
\description{
pam2bioindex estimates various biodiversity indices for a
certain PAM.
}
\details{
The biodiversity indices can be found in Soberón and Cavner (2015).
}
\examples{
set.seed(111)
pam <- matrix(rbinom(100,1,0.3),nrow = 10,ncol = 10)
bioindices <- bamm::pam2bioindex(pam=pam,biodiv_index="all")
# Return results as sparse models
bioindices <- bamm::pam2bioindex(pam=pam,biodiv_index="all",as_sparse=TRUE)
bioindices@alpha
bioindices@omega
bioindices@dispersion_field
}
\references{
\insertRef{Soberon2015}{bamm}
}
\author{
Luis Osorio-Olvera & Jorge Soberón
}
