% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-functions.R
\name{set_confidential_rr3}
\alias{set_confidential_rr3}
\title{Specify RR3 Confidentialization}
\usage{
set_confidential_rr3(mod)
}
\arguments{
\item{mod}{An object of class \code{"bage_mod"},
created with \code{\link[=mod_pois]{mod_pois()}},
\code{\link[=mod_binom]{mod_binom()}}, or \code{\link[=mod_norm]{mod_norm()}}.}
}
\value{
A revised version of \code{mod}.
}
\description{
Specify a confidentialization procedure
where the outcome variable
is randomly rounded to a multiple of 3.
}
\details{
\code{set_confidential_rr3()} can only be used with
Poisson and binomial models (created with
\code{\link[=mod_pois]{mod_pois()}} and \code{\link[=mod_binom]{mod_binom()}}.)

Random rounding to base 3 (RR3) is a confidentialization
technique that is sometimes applied by statistical
agencies. The procedure for randomly-rounding
an integer value \eqn{n} is as follows:
\itemize{
\item If \eqn{n} is divisible by 3, leave it unchanged
\item If dividing \eqn{n} by 3 leaves a remainder of 1, then
round down (subtract 1) with probability 2/3,
and round up (add 2) with probability 1/3.
\item If dividing \eqn{n} by 3 leaves a remainder of 1,
then round down (subtract 2)
with probability 1/3, and round up (add 1)
with probability 2/3.
}

If \code{set_confidential_rr3()} is applied to
a fitted model, \code{set_confidential_rr3()}
\link[=unfit]{unfits}
the model, deleting existing estimates.
}
\examples{
## 'injuries' variable in 'nzl_injuries' dataset
## has been randomly rounded to base 3
mod <- mod_pois(injuries ~ age:sex + ethnicity + year,
                data = nzl_injuries,
                exposure = popn) |>
  set_confidential_rr3() |>
  fit()
}
\seealso{
\itemize{
\item \link{confidential} Overview of confidentialization procedures
currently modeled in \strong{bage}
\item \code{\link[=mod_pois]{mod_pois()}}, \code{\link[=mod_binom]{mod_binom()}}, \code{\link[=mod_norm]{mod_norm()}} Specify a
model for rates, probabilities, or means
}
}
