% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_run_scheduled_instances}
\alias{ec2_run_scheduled_instances}
\title{Run Scheduled Instances}
\usage{
ec2_run_scheduled_instances(
  LaunchSpecification,
  ScheduledInstanceId,
  ClientToken = NULL,
  DryRun = NULL,
  InstanceCount = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{LaunchSpecification}{Object. The launch specification.}

\item{ScheduledInstanceId}{Character. The Scheduled Instance ID.}

\item{ClientToken}{Character. Unique, case-sensitive identifier that ensures the idempotency of the request.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{InstanceCount}{Integer.   The number of instances.  Default: 1  [optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Run Scheduled Instances
}
\section{LaunchSpecification}{

The launch specification. You must match the
instance type, Availability Zone, network, and platform of the schedule
that you purchased.
}

\section{ScheduledInstanceId}{

The Scheduled Instance
ID.
}

\section{ClientToken}{

Unique, case-sensitive identifier that ensures
the idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring Idempotency}.
}

\section{DryRun}{

Checks
whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{InstanceCount}{


The number of instances.

Default: 1
}

