% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{ggstrat_label}
\alias{ggstrat_label}
\title{Plots text lables alongside a stratigraphic section}
\usage{
ggstrat_label(
  df,
  section_name,
  use_theme = NULL,
  label = "stratlayer_sample",
  ylim = NULL,
  ybreaks = 7
)
}
\arguments{
\item{df}{A data frame containing stratigraphic data.
Must include columns \code{stratsection_name}, \code{stratlayer_order},
\code{grainsize}, \code{depth}, and the column specified by \code{layer_fill}.}

\item{section_name}{Character string giving the section name to filter "stratsection_name".}

\item{use_theme}{A ggplot2 theme object to apply to the plot, e.g., "theme_avstrat".}

\item{label}{Character strin gnaming the column to use for labels. Default is "SampleID".}

\item{ylim}{Numeric vector of length 2 giving y-axis limits (optional).}

\item{ybreaks}{Number of breaks on the y-axis.}
}
\value{
A ggplot object showing SampleIDs plotted by depth in section.
}
\description{
Uses ggplot2 to plot any character column associated with stratigraphic data
such as SampleID at the correct depths for their corresponding
layers. Connecting lines extend to the left of the plot to point to plotted
layers. It is designed to be combined with a stratigraphic section plot created by
\code{\link[=ggstrat]{ggstrat()}} using the \link[patchwork:patchwork-package]{patchwork::patchwork} framework for arranging multiple
ggplot objects.
}
\examples{
# Example 1: Basic usage
example_data_strat |>
  ggstrat_label(section_name = "21LSHD02",
              label = "SampleID")

# Example 2: Combine with a stratigraphic section plot using patchwork
if (requireNamespace("patchwork", quietly = TRUE)) {
  stratsection <- example_data_strat |>
    ggstrat(section_name = "21LSHD02")

  samples <- example_data_strat |>
    ggstrat_label(section_name = "21LSHD02",
              label = "SampleID")

  stratsection + samples
}

}
