% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{ggstrat_column}
\alias{ggstrat_column}
\title{Plot a simple stratigraphic column}
\usage{
ggstrat_column(
  df,
  section_name,
  use_theme = NULL,
  ylim = NULL,
  depth_units = c("cm", "m"),
  ybreaks = 7,
  layer_fill = "layer_type",
  layer_fill_color = "stratpal_rpg",
  layer_border_color = "black",
  layer_border_linewidth = 0.2
)
}
\arguments{
\item{df}{A data frame containing stratigraphic data.
Must include columns \code{stratsection_name}, \code{stratlayer_order},
\code{grainsize}, \code{depth}, and \code{stratlayer_type}.}

\item{section_name}{Character string giving the section name to filter "stratsection_name".}

\item{use_theme}{A ggplot2 theme object to apply to the plot, e.g., "theme_avstrat".}

\item{ylim}{Numeric vector of length 2 giving y-axis limits (optional).}

\item{depth_units}{Units to use for depth (y-axis) scale, either "cm" (default) or "m".}

\item{ybreaks}{Number of breaks on the y-axis.}

\item{layer_fill}{Character string naming the column to use for fill. If
using anything other than "layer_type" from the template, will need to make
a new palette.}

\item{layer_fill_color}{Palette object to use for fill colors.}

\item{layer_border_color}{Border color for polygons.}

\item{layer_border_linewidth}{Border line width for polygons.}
}
\value{
A ggplot object showing a schematic stratigraphic column.
}
\description{
Uses ggplot2 to create a simple depth-only stratigraphic section plot with no
variable mapped to the x-axis. Each layer is drawn as a fixed-width rectangle.
}
\examples{
example_data_strat |>
  ggstrat_column(section_name = "21LSHD02")
}
