% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_auto_visual_inference.R
\name{AUTO_VI$null_vss}
\alias{AUTO_VI$null_vss}
\title{Simulate null plots and predict the visual signal strength}
\arguments{
\item{draws}{Integer. Number of simulation draws.}

\item{fitted_model}{Model. A model object, e.g. \code{lm}.}

\item{keras_model}{Keras model. A trained computer vision model.}

\item{null_method}{Function. A method to simulate residuals from the null
hypothesis distribution. For \code{lm}, the recommended method is residual
rotation \code{\link[=AUTO_VI$rotate_resid]{AUTO_VI$rotate_resid()}}.}

\item{node_index}{Integer. An index indicating which node of the output layer
contains the visual signal strength. This is particularly useful
when the keras model has more than one output nodes.}

\item{keep_null_data}{Boolean. Whether to keep the simulated null data.}

\item{keep_null_plot}{Boolean. Whether to keep the simulated null plots.}

\item{extract_feature_from_layer}{Character/Integer. A layer name or an
integer layer index for extracting features from a layer.}
}
\value{
A tibble.
}
\description{
This function simulates null plots from the null hypothesis
distribution, and predicts the visual signal strength.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{AUTO_VI$null_vss(
  draws = 100L,
  fitted_model = self$fitted_model,
  keras_model = self$keras_model,
  null_method = self$null_method,
  node_index = self$node_index,
  keep_null_data = FALSE,
  keep_null_plot = FALSE,
  extract_feature_from_layer = NULL
)
}\if{html}{\out{</div>}}
}
}
\examples{
keras_model <- try(get_keras_model("vss_phn_32"))
if (!inherits(keras_model, "try-error")) {
  myvi <- auto_vi(lm(dist ~ speed, data = cars), keras_model)

  myvi$null_vss()
}
}
