% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cursors.R
\name{am_cursor}
\alias{am_cursor}
\title{Create a cursor at a position in a text object}
\usage{
am_cursor(obj, position, heads = NULL)
}
\arguments{
\item{obj}{An Automerge object ID (must be a text object)}

\item{position}{Integer position in the text (0-based inter-character position)}

\item{heads}{Optional list of change hashes (raw vectors) to create the cursor
at a historical document state. If \code{NULL} (default), uses the current state.}
}
\value{
An \code{am_cursor} object (external pointer) that can be used with
\code{\link[=am_cursor_position]{am_cursor_position()}} to retrieve the current position
}
\description{
Cursors provide stable references to positions within text objects that
automatically adjust as the text is edited. This enables features like
maintaining selection positions across concurrent edits in collaborative
editing scenarios.
}
\section{Indexing Convention}{

\strong{Cursor positions use 0-based indexing} (unlike list indices which are
1-based). This is because positions specify locations \strong{between} characters,
not the characters themselves:
\itemize{
\item Position 0 = before the first character
\item Position 1 = between 1st and 2nd characters
\item Position 5 = after the 5th character
}

For the text "Hello":
\preformatted{
  H e l l o
 0 1 2 3 4 5  <- positions (0-based, between characters)
}

This matches \code{am_text_splice()} behavior. Positions count Unicode code points
(characters), not bytes.
}

\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "text", am_text("Hello World"))
text_obj <- am_get(doc, AM_ROOT, "text")

# Create cursor at position 5 (after "Hello", before " ")
cursor <- am_cursor(text_obj, 5)
cursor

# Modify text before cursor
am_text_splice(text_obj, 0, 0, "Hi ")

# Cursor position automatically adjusts
new_pos <- am_cursor_position(cursor)
new_pos  # 8 (cursor moved by 3 characters)

am_close(doc)

}
