% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-funcs-type.R
\name{cast}
\alias{cast}
\title{Change the type of an array or column}
\usage{
cast(x, to, safe = TRUE, ...)
}
\arguments{
\item{x}{an \code{Array}, \code{Table}, \code{Expression}, or similar Arrow data object.}

\item{to}{\link{DataType} to cast to; for \link{Table} and \link{RecordBatch},
it should be a \link{Schema}.}

\item{safe}{logical: only allow the type conversion if no data is lost
(truncation, overflow, etc.). Default is \code{TRUE}.}

\item{...}{specific \code{CastOptions} to set}
}
\value{
An \link{Expression}
}
\description{
This is a wrapper around the \verb{$cast()} method that many Arrow objects have.
It is more convenient to call inside \code{dplyr} pipelines than the method.
}
\examples{
\dontrun{
mtcars |>
  arrow_table() |>
  mutate(cyl = cast(cyl, string()))
}
}
\seealso{
\code{\link{data-type}} for a list of \link{DataType} to be used with \code{to}.

\href{https://arrow.apache.org/docs/cpp/api/compute.html?highlight=castoptions#arrow\%3A\%3Acompute\%3A\%3ACastOptions}{Arrow C++ CastOptions documentation} # nolint
for the list of supported CastOptions.
}
\keyword{internal}
