% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bias_spec.R
\name{build_bias_specification}
\alias{build_bias_specification}
\title{Build bias specification for Stan}
\usage{
build_bias_specification(
  num_biases,
  b_types = character(),
  s_types = character(),
  d_types = character(),
  e_types = character(),
  en_types = character(),
  ab_params = list(),
  skn_params = list(),
  de_params = list(),
  ex_params = list(),
  exneg_params = list()
)
}
\arguments{
\item{num_biases}{Integer. Total number of biases.}

\item{b_types}{Character vector of biases with beta priors.}

\item{s_types}{Character vector of biases with skew-normal priors.}

\item{d_types}{Character vector of biases with Laplace priors.}

\item{e_types}{Character vector of biases with exponential priors.}

\item{en_types}{Character vector of biases with negative exponential priors.}

\item{ab_params}{Named list of beta prior parameters.}

\item{skn_params}{Named list of skew-normal prior parameters.}

\item{de_params}{Named list of Laplace prior parameters.}

\item{ex_params}{Named list of exponential prior parameters.}

\item{exneg_params}{Named list of negative exponential prior parameters.}
}
\value{
A list defining bias structure and prior parameters.
}
\description{
Build bias specification for Stan
}
\examples{
## Example 1: Single bias with a Beta prior

bias_spec <- build_bias_specification(
  num_biases = 1,
  b_types = "Confounding",
  ab_params = list(
    Confounding = c(2, 5)
  )
)

bias_spec

## Example 2: Multiple biases with different prior families

bias_spec <- build_bias_specification(
  num_biases = 2,
  b_types = "Confounding",
  s_types = "Selection Bias",
  ab_params = list(
    Confounding = c(2, 5)
  ),
  skn_params = list(
    `Selection Bias` = c(0, 0.2, 5)
  )
)

bias_spec

## Example 3: Exponential bias prior

bias_spec <- build_bias_specification(
  num_biases = 1,
  e_types = "Measurement Errors",
  ex_params = list(
    `Measurement Errors` = 1.5
  )
)

bias_spec

}
\references{
Kabali C (2025). AppRaise: Software for quantifying evidence uncertainty
in systematic reviews using a posterior mixture model. \emph{Journal of
Evaluation in Clinical Practice}, 31, 1-12. https://doi.org/10.1111/jep.70272.
}
\seealso{
\itemize{
\item \code{\link{simulate_bias_priors}} for sampling bias prior distributions
\item \code{\link{run_appraise_model}} for posterior inference
\item \code{vignette("appraise-introduction")} for a full workflow
}
}
