% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ab_comparison.R
\name{anki_ab_comparison}
\alias{anki_ab_comparison}
\title{A/B Comparison}
\usage{
anki_ab_comparison(
  path = NULL,
  profile = NULL,
  by = "note_type",
  min_reviews = 100
)
}
\arguments{
\item{path}{Path to collection.anki2 (auto-detected if NULL)}

\item{profile}{Profile name (first profile if NULL)}

\item{by}{Comparison dimension: "note_type", "deck", "tag", "created_period" (default "note_type")}

\item{min_reviews}{Minimum reviews per group to include (default 100)}
}
\value{
A tibble with comparison statistics
}
\description{
Compare retention, efficiency, and performance across different
note types, deck settings, card formats, or custom groups.
}
\examples{
\dontrun{
# Compare note types
comp <- anki_ab_comparison(by = "note_type")

# Compare decks
comp <- anki_ab_comparison(by = "deck")
}
}
