% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{expectation.dist}
\alias{expectation.dist}
\title{Expectation of a Function Applied to a \code{dist} Object}
\usage{
\method{expectation}{dist}(x, g = function(t) t, ..., control = list())
}
\arguments{
\item{x}{A \code{dist} object.}

\item{g}{Characteristic function of interest, defaults to identity.}

\item{...}{Additional arguments to pass to \code{g}.}

\item{control}{A list of control parameters:
compute_stats - Logical, whether to compute CIs for the expectations, defaults
to FALSE
n             - Integer, the number of samples to use for the MC estimate,
defaults to 10000L
alpha         - Real, the significance level for the confidence interval,
defaults to 0.05}
}
\value{
If \code{compute_stats} is FALSE, then the estimate of the expectation,
otherwise a list with the following components:
value - The estimate of the expectation
ci    - The confidence intervals for each component of the expectation
n     - The number of samples
}
\description{
Expectation operator applied to \code{x} of type \code{dist}
with respect to a function \code{g}. Optionally, constructs a confidence interval
for the expectation estimate using the Central Limit Theorem.
}
