% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Interface.R
\name{validate_tabular}
\alias{validate_tabular}
\alias{validate_rearrangement}
\title{Validate tabular AIRR data}
\usage{
validate_tabular(data, schema)

validate_rearrangement(data)
}
\arguments{
\item{data}{\code{data.frame} of tabular data to validate.}

\item{schema}{\code{Schema} object defining the data standard of the table.}
}
\value{
Returns \code{TRUE} if the input \code{data} is compliant and
          \code{FALSE} if not.
}
\description{
\code{validate_tabular} validates compliance of the contents of a \code{data.frame} 
to the AIRR standards.
}
\details{
\code{validate_rearrangement} validates the standards compliance of AIRR Rearrangement 
data stored in a \code{data.frame}
}
\examples{
# Get path to the rearrangement-example file
file <- system.file("extdata", "rearrangement-example.tsv.gz", package="airr")

# Load data file
df <- read_rearrangement(file)

# Validate a data.frame against the Rearrangement schema
validate_rearrangement(df)

}
