% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hobo_do.R
\name{process_weather_month}
\alias{process_weather_month}
\title{process_weather_month}
\usage{
process_weather_month(file_path, month, year = 2024, zone)
}
\arguments{
\item{file_path}{Path to the monthly CSV file.}

\item{month}{Month number (1–12) covered by the file.}

\item{year}{Four-digit year. Default 2024.}

\item{zone}{Character label for the weather station / region.}
}
\value{
A data frame with columns \code{day}, \code{pressure_hpa},
  \code{temp}, \code{humidity_percent}, \code{wind_ms}, \code{rain_mm},
  \code{daylight_hr}, \code{radiation}, \code{date}, and \code{zone}.
}
\description{
Import and tidy a monthly weather CSV file downloaded from a
  Taiwan Central Weather Administration station. Column selection is done via
  regex so minor header changes are handled gracefully.
}
\examples{
\dontrun{
df <- process_weather_month("path/to/2024-01.csv", month = 1, year = 2024,
                            zone = "site_A")
}
}
