% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{descriptive_statistic}
\alias{descriptive_statistic}
\title{descriptive_statistic}
\usage{
descriptive_statistic(data, vars, groups, digits = 2)
}
\arguments{
\item{data}{A data frame.}

\item{vars}{<[`tidy-select`][dplyr::dplyr_tidy_select]> Columns to summarise.}

\item{groups}{<[`tidy-select`][dplyr::dplyr_tidy_select]> Grouping columns.}

\item{digits}{Number of decimal places to round to. Default is 2.}
}
\value{
A tibble with one row per group and two summary columns per variable
  (`<var>_mean_sd` and `<var>_min_max`).
}
\description{
Compute grouped mean ± SD and min–max summary statistics for
  one or more numeric variables.
}
\examples{
df <- data.frame(group = c("A","A","B","B"), value = c(1.1, 2.3, 3.5, 4.7))
descriptive_statistic(df, vars = value, groups = group)
}
