% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{package}
\name{VectrixDB-package}
\alias{VectrixDB-package}
\title{VectrixDB: Lightweight Vector Database with Embedded Machine Learning Models}
\description{
A lightweight vector database for text retrieval in R with embedded machine learning models and no external API (Application Programming Interface) keys. Supports dense and hybrid search, optional HNSW (Hierarchical Navigable Small World) approximate nearest-neighbor indexing, faceted filters with ACL (Access Control List) metadata, command-line tools, and a local dashboard built with 'shiny'.

VectrixDB is a lightweight vector database with embedded machine learning models
that do not require external API (application programming interface) keys.
It supports dense, hybrid, and graph-based search modes and includes a built-in
dashboard.
}
\section{Main Functions}{

\itemize{
\item \code{\link{Vectrix}} - Simple API for text-in, results-out workflow
\item \code{\link{VectrixDB}} - Advanced database interface
\item \code{\link{Collection}} - Vector collection management
\item \code{\link{vectrix_serve}} - Start REST API server
}
}

\section{Search Modes}{

\itemize{
\item dense - Semantic vector search
\item sparse - BM25 keyword search
\item hybrid - Combined dense + sparse
\item ultimate - Full pipeline with reranking
\item neural - ColBERT + cross-encoder
}
}

\examples{
\dontrun{
# Simple usage
db <- Vectrix$new("my_docs")
db$add(c("Python is great", "R is awesome", "Julia is fast"))
results <- db$search("programming language")
print(results$top()$text)
}

}
\seealso{
Useful links:
\itemize{
  \item \url{https://knowusuboaky.github.io/vectrixdb-r/}
  \item \url{https://github.com/knowusuboaky/vectrixdb-r}
  \item Report bugs at \url{https://github.com/knowusuboaky/vectrixdb-r/issues}
}

}
\author{
\strong{Maintainer}: Kwadwo Daddy Nyame Owusu Boakye \email{kwadwo.owusuboakye@outlook.com}

}
\keyword{internal}
