% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_Ts.R
\name{calculate_Ts}
\alias{calculate_Ts}
\title{Calculate the Surface Temperature (Ts)}
\usage{
calculate_Ts(albedo, ndvi, Ta, output_path = NULL, verbose = FALSE)
}
\arguments{
\item{albedo}{RasterLayer/SpatRaster of albedo values}

\item{ndvi}{RasterLayer/SpatRaster of NDVI values}

\item{Ta}{RasterLayer/SpatRaster of air temperature (Ta) in Kelvin}

\item{output_path}{File path to save the Ts raster (optional)}

\item{verbose}{Logical; if TRUE, prints information about dry/wet edges, T_min/T_max, and unit info. Default is TRUE.}
}
\value{
SpatRaster of surface temperature (Ts) in the same unit as Ta
}
\description{
This function calculates the surface temperature (Ts) from three rasters: albedo, NDVI,
and air temperature (Ta). The resulting Ts raster will have the same unit as Ta.
}
\examples{
library(terra)

albedo_raster <- rast(system.file("extdata", "albedo_mini.tif", package = "Ts"))
Ta_raster     <- rast(system.file("extdata", "Ta_mini.tif", package = "Ts"))
ndvi_raster   <- rast(system.file("extdata", "ndvi_mini.tif", package = "Ts"))

output_path <- tempfile(fileext = ".tif")

calculate_Ts(
  albedo = albedo_raster,
  Ta     = Ta_raster,
  ndvi   = ndvi_raster,
  output_path = output_path,
  verbose = TRUE
)

print(output_path)

}
