# Ts Package

The **Ts** package provides tools to calculate the **Surface Temperature (Ts)** from raster data.  
It uses **albedo**, **NDVI**, and **air temperature (Ta)** to generate the Ts raster.

## Units

- The input air temperature raster (`Ta`) must be in **Kelvin (K)**.  
- The resulting surface temperature raster (`Ts`) will be in the **same unit as Ta**.

## Raster requirements

- Input rasters (`albedo`, `ndvi`, `Ta`) do **not need to have the same CRS or extent**, the function will:
  - Align the CRS of all rasters to that of `albedo`.
  - Resample `ndvi` and `Ta` to the resolution of `albedo`.
  - Crop all rasters to the **intersection of their extents**.

- For meaningful results, input rasters should ideally cover roughly the same area.

## Installation

You can install the development version of **Ts** directly from your local folder:

```r
# Install from local directory
devtools::install("path/to/Ts")
