% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.TLSW.R
\name{summary.TLSW}
\alias{summary.TLSW}
\title{Summary of Output Provided by the \code{TLSW} Function}
\usage{
\method{summary}{TLSW}(object, ...)
}
\arguments{
\item{object}{A \code{TLSW} object.}

\item{...}{Other arguments.}
}
\value{
No return value, called for side effects
}
\description{
Summary method for objects of class \code{TLSW}.
}
\details{
Prints out information about a \code{TLSW} object. If spectral
estimation was performed, then the type of smoothing and binwidth is printed,
along with the differencing performed if it is used, the maximum wavelet
scale analysed, and whether or not boundary handling was used. If trend
estimation is performed, then the type of wavelet thresholding and transform
used is printed, as well as the maximum wavelet scale used, whether or not boundary handling was used,
and the significance of the confidence interval if it was calculated.
}
\examples{
# simulates an example time series and estimates its trend and evolutionary wavelet spectrum

spec <- matrix(0, nrow = 10, ncol = 2^10)

spec[1, ] <- seq(from = 1, to = 10, length = 1024)

trend <- sin(pi * (seq(from = 0, to = 4, length = 1024)))

set.seed(1)

x <- TLSWsim(trend = trend, spec = spec)

x.TLSW <- TLSW(x)

summary(x.TLSW)

}
\references{
McGonigle, E. T., Killick, R., and Nunes, M. (2022). Modelling
time-varying first and second-order structure of time series via wavelets
and differencing. \emph{Electronic Journal of Statistics}, 6(2), 4398-4448.

McGonigle, E. T., Killick, R., and Nunes, M. (2022). Trend
locally stationary wavelet processes. \emph{Journal of Time Series
Analysis}, 43(6), 895-917.
}
\seealso{
\code{\link{TLSW}}, \code{\link{print.TLSW}}
}
