% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equal_surplus_division_unions.R
\name{equal_surplus_division_unions}
\alias{equal_surplus_division_unions}
\title{Equal Surplus Division value with a priori unions}
\usage{
equal_surplus_division_unions(
  characteristic_func,
  union,
  n_players = 0,
  type = 1
)
}
\arguments{
\item{characteristic_func}{The valued function defined on the subsets of the number
of players}

\item{union}{List of vectors indicating the a priori unions between the
players.}

\item{n_players}{Only used if \code{characteristic_func} is a \code{function}.
The number of players in the game.}

\item{type}{Number indicating the type of equal surplus division value to compute
following Alonso-Meijide et al. (2020). Values 1, 2 and 3 are implemented.}
}
\value{
The equal surplus division value for each player
}
\description{
Calculate the equal surplus division value in games with a priori unions
}
\examples{
n <- 3
v <- function(coalition) {
 size <- length(coalition)
 if (size <= 1) {
   return(0)
 } else if (size == 2) {
   return(10)
 } else if (size == 3) {
   return(24)
 } else {
   return(0)
 }
}
union <- list(1:4,5:n)
equal_surplus_division_unions(v,union,n,type = 1)

v <- c(1,1,2,1,2,2,2)
union <- list(c(1,2),c(3))
equal_surplus_division_unions(v, union, type = 2)

}
\references{
Alonso-Meijide, J. M., Costa, J., García-Jurado, I., &
Gonçalves-Dosantos, J. C. (2020). On egalitarian values for cooperative games
with a priori unions. Top, 28(3), 672-688.
}
