% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_report.R
\name{generate_report}
\alias{generate_report}
\title{Generate Markdown Report for QCA Analysis}
\usage{
generate_report(
  result,
  output_file = "qca_report.md",
  format = c("full", "simple"),
  title = "QCA Analysis Report",
  dat = NULL,
  desc_vars = NULL,
  include_chart = TRUE,
  chart_symbol_set = c("unicode", "ascii", "latex"),
  chart_level = c("term", "summary"),
  solution_note = TRUE,
  solution_note_style = c("simple", "detailed"),
  solution_note_lang = c("en", "ja")
)
}
\arguments{
\item{result}{A result object from any Sweep function with
\code{return_details = TRUE}.}

\item{output_file}{Character. Path to output markdown file.}

\item{format}{Character. Report format: \code{"full"} or \code{"simple"}.}

\item{title}{Character. Report title.}

\item{dat}{Optional data frame. Original data for descriptive statistics.}

\item{desc_vars}{Optional character vector. Variables for descriptive statistics.
If NULL and dat is provided, uses Yvar and Xvars from params.}

\item{include_chart}{Logical. If TRUE (default), includes configuration charts
(Fiss-style tables) in the report for each threshold.}

\item{chart_symbol_set}{Character. Symbol set for configuration charts:
\code{"unicode"} (default), \code{"ascii"}, or \code{"latex"}.}

\item{chart_level}{Character. Chart aggregation level:
\code{"term"} (default) produces solution-term level charts following Fiss (2011)
notation, where each column represents one prime implicant (sufficient
configuration). This format is recommended for academic publications.
\code{"summary"} produces threshold-level summaries where each
column represents one threshold, aggregating all configurations.}

\item{solution_note}{Logical. If TRUE (default), adds a note when multiple
equivalent solutions exist explaining that M1 is shown.}

\item{solution_note_style}{Character. Style of solution note:
\code{"simple"} (default) or \code{"detailed"} (includes EPIs).}

\item{solution_note_lang}{Character. Language for solution notes:
\code{"en"} (default) or \code{"ja"}.}
}
\value{
Invisibly returns the path to the generated report.
}
\description{
Creates a markdown report from QCA analysis results.
Supports two formats: "full" (comprehensive) and "simple" (for manuscripts).
}
\examples{
\dontrun{
data(sample_data)
thrX <- c(X1 = 7, X2 = 7, X3 = 7)

result <- otSweep(
  dat = sample_data,
  outcome = "Y",
  conditions = c("X1", "X2", "X3"),
  sweep_range = 6:8,
  thrX = thrX,
  return_details = TRUE
)

# With descriptive statistics and configuration charts
generate_report(result, "my_report.md", format = "full", 
                dat = sample_data, include_chart = TRUE)

# Without configuration charts
generate_report(result, "my_report.md", format = "simple",
                include_chart = FALSE)

# With Fiss-style term-level charts (default, recommended for publications)
generate_report(result, "my_report.md", format = "full")

# With threshold-level summary charts
generate_report(result, "my_report.md", format = "full",
                chart_level = "summary")

# With detailed solution notes (including EPIs)
generate_report(result, "my_report.md", format = "full",
                solution_note_style = "detailed")
}
}
