% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.pairwiseFST.R
\name{compute.pairwiseFST}
\alias{compute.pairwiseFST}
\title{Compute pairwise population population FST matrix (and possibly all pairwise SNP-specific FST)}
\usage{
compute.pairwiseFST(
  x,
  method = "Anova",
  min.cov.per.pool = -1,
  max.cov.per.pool = 1e+06,
  min.indgeno.per.pop = -1,
  min.maf = -1,
  output.snp.values = FALSE,
  nsnp.per.bjack.block = 0,
  verbose = TRUE
)
}
\arguments{
\item{x}{A pooldata object containing Pool-Seq information or a countdata object containing allele count information}

\item{method}{Either "Anova" (default method as described in the manuscript) or "Identity" (relies on an alternative modeling consisting in estimating unbiased Probability of Identity within and across pairs of pools)}

\item{min.cov.per.pool}{For Pool-Seq data (i.e., pooldata objects) only: minimal allowed read count (per pool). If at least one pool is not covered by at least min.cov.perpool reads, the position is discarded in the corresponding pairwise comparisons}

\item{max.cov.per.pool}{For Pool-Seq data (i.e., pooldata objects) only: maximal allowed read count (per pool). If at least one pool is covered by more than min.cov.perpool reads, the position is discarded in the corresponding pairwise comparisons.}

\item{min.indgeno.per.pop}{For allele count data (i.e., countdata objects) only: minimal number of overall counts required in each population. If at least one pop is not genotyped for at least min.indgeno.per.pop (haploid) individual, the position is discarded}

\item{min.maf}{Minimal allowed Minor Allele Frequency (computed from the ratio over all read counts for the reference allele over the read coverage)  in the pairwise comparisons.}

\item{output.snp.values}{If TRUE, provide SNP-specific pairwise FST for each comparisons (may lead to a huge result object if the number of pools and/or SNPs is large)}

\item{nsnp.per.bjack.block}{Number of consecutive SNPs within a block for block-jackknife (default=0, i.e., no block-jackknife sampling)}

\item{verbose}{If TRUE extra information is printed on the terminal}
}
\value{
An object of class pairwisefst (see help(pairwisefst) for details)
}
\description{
Compute pairwise population population FST matrix (and possibly all pairwise SNP-specific FST)
}
\examples{
 make.example.files(writing.dir=tempdir())
 pooldata=popsync2pooldata(sync.file=paste0(tempdir(),"/ex.sync.gz"),poolsizes=rep(50,15))
 PairwiseFST=compute.pairwiseFST(pooldata)
}
\seealso{
To generate pooldata object, see \code{\link{vcf2pooldata}}, \code{\link{popsync2pooldata}},\code{\link{genobaypass2pooldata}} or \code{\link{genoselestim2pooldata}}. To generate coundata object, see \code{\link{genobaypass2countdata}} or \code{\link{genotreemix2countdata}}.
}
