% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.metadata.r
\name{setInstrDesc}
\alias{setInstrDesc}
\alias{instr_descriptor<-}
\title{Set the "instr.desc" attribute}
\usage{
setInstrDesc(x, instr.desc)

instr_descriptor(x) <- value
}
\arguments{
\item{x}{a \code{generic_spct} object or a \code{summary_generic_spct}
object.}

\item{instr.desc, value}{a \code{list}, \code{instr_desc} object, or
\code{NULL}.}
}
\value{
\code{x}, with the value of its \code{"instr.desc"} attribute set to
  the value of the argument passed to \code{instr.desc} or to \code{value}.
}
\description{
Function to set by reference the \code{"instr.desc"} attribute of an existing
\code{generic_spct} or derived-class object, or of a
\code{summary_generic_spct} or derived-class object.
}
\details{
This function alters \code{x} itself by reference and in addition
  returns \code{x} invisibly. If \code{x} is not a \code{generic_spct} object,
  \code{x} is not modified, silently. If \code{inst.desc = NULL} is passed
  in the call, the attribute \code{"instr.desc"} is removed.
  \emph{This function is very rarely called from user code.}
}
\note{
The fields to be passed in the list \code{instr.desc} in part vary
depending on the instrument brand and model.
}
\seealso{
Other measurement metadata functions: 
\code{\link{add_attr2tb}()},
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getSoluteProperties}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrSettings}()},
\code{\link{setSoluteProperties}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{spct_metadata}()},
\code{\link{subset_attributes}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
